<?php
/* --------------------------------------------------------------
  ReadServiceInterface.php 2020-02-24
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitEan\Service;

use Gambio\Shop\Attributes\SellingUnitEan\Repository\Dto\EanCollectionDto;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;

/**
 * Interface ReadServiceInterface
 * @package Gambio\Shop\Attributes\SellingUnitEan\Service
 */
interface ReadServiceInterface
{
    /**
     * @param ProductId                             $productId
     * @param ModifierIdentifierCollectionInterface $modifiers
     *
     * @return EanCollectionDto
     */
    public function getAttributesEanValuesByProduct(
        ProductId $productId,
        ModifierIdentifierCollectionInterface $modifiers
    ) : EanCollectionDto;
}